#!/bin/sh

if [ $# -ne 3 ]; then
  echo "usage. $0 filename row(0-) column(0-)"
  exit 255
fi

FILENAME=$1
if [ ! -r "${FILENAME}" ]; then
  echo "not found or not read. file name: ${FILENAME}"
  exit 255
fi

ROW_INDEX=`expr $2 \+ 1`
COLUMN_INDEX=`expr $3 \+ 1`

# get row string
ROW_STRING=`sed -n ${ROW_INDEX}p "${FILENAME}"`

# get cell string
CELL_STRING=`echo ${ROW_STRING} | cut -d ',' -f ${COLUMN_INDEX}`

echo ${CELL_STRING}
